using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Pcie1230;


namespace iopanel
{
    public partial class Form1 : Form
    {

        CheckBox[] CheckBoxDI = new CheckBox[32];
        CheckBox[] CheckBoxDO = new CheckBox[32];
        int m_CurCardId;
        uint[] dodata=new uint[32];
        public Form1()
        {
            InitializeComponent();



            for (int i = 0; i < 32; i++)
            { 
            CheckBoxDI[i] = new System.Windows.Forms.CheckBox();
            CheckBoxDI[i].Size = new System.Drawing.Size(48, 16);
            CheckBoxDI[i].Location =new System .Drawing.Point(40 + (i % 8) * 50, 36 + 24 + 24 * (i / 8));
            CheckBoxDI[i].Text = "DI" + i;
            CheckBoxDI[i].Enabled = false;
            this.Controls.Add(CheckBoxDI[i]);
            }

            for (int i = 0; i < 32; i++)
            {
                CheckBoxDO[i] = new System.Windows.Forms.CheckBox();
                CheckBoxDO[i].Size = new System.Drawing.Size(48, 16);
                CheckBoxDO[i].Location = new System.Drawing.Point(40 + (i % 8) * 50, 36  + 150 + 24 + 24 * (i / 8));
                CheckBoxDO[i].Text = "DO" + i;
                CheckBoxDO[i].CheckState = CheckState.Unchecked;
                this.Controls.Add(CheckBoxDO[i]);
            }

        m_CurCardId = 15;
        this.label3.Text= "Current Board Id: "  + m_CurCardId;

        int rc;
        rc = CPcie1230.Pci1230Open(m_CurCardId);
        if   (rc != CPcie1230.PCI1230Success)
            {
                MessageBox.Show("Open PCI-1230 fail");
                return ;
            }
           rc= CPcie1230.Pci1230Write(m_CurCardId,0);

            timer1.Enabled = true;



        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            int i;
            uint din=0;
            int rc;
            for (i = 0; i < 32; i++)
            {
                CPcie1230.Pci1230ReadDoBit(m_CurCardId, i, ref dodata[i]);
                rc = CPcie1230.Pci1230ReadDiBit(m_CurCardId, i,ref din);
                if (din!=0 )
                {
                    CheckBoxDI[i].Checked =true ;
                }
                else
                {
                    CheckBoxDI[i].Checked = false;
                }

                if (CheckBoxDO[i].CheckState == CheckState.Unchecked )
                {
                    rc = CPcie1230.Pci1230WriteDoBit(m_CurCardId, i, 0);
                }
                else
                {
                    rc = CPcie1230.Pci1230WriteDoBit(m_CurCardId, i, 1);
                }
 
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            CPcie1230.Pci1230Close(m_CurCardId);
        }

    }
}