// panelDlg.cpp : implementation file
//

#include "stdafx.h"
#include "panel.h"
#include "panelDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
#ifdef _WIN64
#pragma comment(lib,"PCI1230\\x64\\PCI1230.lib")
#else
#pragma comment(lib,"PCI1230\\x86\\PCI1230.lib")
#endif
#include "pci1230.h"
#include ".\paneldlg.h"

// globale 
unsigned int g_cardid ;
unsigned int cardid[16];
unsigned int g_writeDo[16] = {0};
int cardnumber;
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPanelDlg dialog

CPanelDlg::CPanelDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPanelDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPanelDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPanelDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPanelDlg)
	// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_COMBO1, m_CardID);
}

BEGIN_MESSAGE_MAP(CPanelDlg, CDialog)
	//{{AFX_MSG_MAP(CPanelDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
//	ON_CBN_EDITCHANGE(IDC_COMBO1, OnEditchangeCombo1)
	//}}AFX_MSG_MAP
//	ON_CBN_DBLCLK(IDC_COMBO1, OnCbnDblclkCombo1)
	ON_CBN_SELCHANGE(IDC_COMBO1, OnCbnSelchangeCombo1)
//	ON_NOTIFY(NM_THEMECHANGED, IDC_COMBO1, OnNMThemeChangedCombo1)
ON_WM_TIMER()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPanelDlg message handlers

BOOL CPanelDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	// open card
	int i ;
	unsigned int error;
	cardnumber = 0;
	CString strTemp;
	// initial card id array
	for(i = 0;i<16;i++)
	{
		cardid[i] = 0;
	}
	for(i=15;i>=0;i--)
	{
		error = Pci1230Open(i);
		if(error == PCI1230Success)
		{
			// find card
			strTemp.Format("%d",i);
			m_CardID.InsertString(cardnumber,strTemp);
			cardid[cardnumber] = i;
			cardnumber++;
		}
	}

	if(cardnumber == 0)
	{
		AfxMessageBox("Open Card Fail");
		return FALSE;
	}
	m_CardID.SetCurSel(0);
	g_cardid = cardid[0];
	// start timer, 100ms 
	SetTimer(0, 50,NULL);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPanelDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPanelDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPanelDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CPanelDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	KillTimer(0);
	// 
	int i = 0;
	for(i=0;i<cardnumber;i++)
	{
		Pci1230Close(i);
	}
	CDialog::OnCancel();
}



void CPanelDlg::OnCbnSelchangeCombo1()
{
	// TODO: ڴӿؼ֪ͨ
	KillTimer(0);
	CString srtGID;
	int i = m_CardID.GetCurSel();
	g_cardid = cardid[i];
	unsigned int  writeDoDat = g_writeDo[g_cardid];
	for(i=0;i<32;i++)
	{
		if( (writeDoDat & (0x01<<i)) != 0 )
		{
			//set check box 
			((CButton *)GetDlgItem(IDC_CHECK1+i))->SetCheck(1);
		}
		else
		{
			((CButton *)GetDlgItem(IDC_CHECK1+i))->SetCheck(0);
		}
	}
	UpdateData(false);
	SetTimer(0,100,NULL);
}

void CPanelDlg::OnNMThemeChangedCombo1(NMHDR *pNMHDR, LRESULT *pResult)
{
	// ùҪʹ Windows XP ߰汾
	//  _WIN32_WINNT  >= 0x0501
	// TODO: ڴӿؼ֪ͨ
	*pResult = 0;
}


void CPanelDlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	UpdateData(TRUE);
		// get date write to do
		unsigned int  writeDoDat = 0;
		int i = 0;
		for(i =0;i<32;i++)
		{
			// if check is checked ,data shift logic or 1
			if(((CButton *)GetDlgItem(IDC_CHECK1+i))->GetCheck())
			{
				writeDoDat |= (0x01<<i);
			}
		}
		g_writeDo[g_cardid] = writeDoDat;
		// write data to pci1230
		Pci1230Write(g_cardid,writeDoDat);
	
		// read di data
		unsigned int readDiDat = 0;
		Pci1230Read(g_cardid,&readDiDat);
		for(i=0;i<32;i++)
		{
			if( (readDiDat & (0x01<<i)) != 0 )
			//if( (writeDoDat & (0x01<<i)) != 0 )
			{
				//set check box 
				((CButton *)GetDlgItem(IDC_CHECK33+i))->SetCheck(1);
			}
			else
			{
				((CButton *)GetDlgItem(IDC_CHECK33+i))->SetCheck(0);
			}
		}
		
		CString srtGID;
		((CComboBox *)GetDlgItem(IDC_COMBO1))->GetWindowText(srtGID);
		g_cardid = atoi(srtGID);

	CDialog::OnTimer(nIDEvent);
}
